<?php
include 'config.php';
session_start();

// ✅ check if logged in as admin
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header("Location: login.php");
    exit();
}

// fetch users
$result = $conn->query("SELECT * FROM users ORDER BY id DESC");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Users Management</title>
</head>
<body>
    <h1>Users</h1>
    <a href="user_create.php">➕ Add New User</a>
    <table border="1" cellpadding="8">
        <tr><th>ID</th><th>Name</th><th>Email</th><th>Role</th><th>Actions</th></tr>
        <?php while($row = $result->fetch_assoc()): ?>
        <tr>
            <td><?= $row['id'] ?></td>
            <td><?= $row['name'] ?></td>
            <td><?= $row['email'] ?></td>
            <td><?= $row['role'] ?></td>
            <td>
                <a href="user_edit.php?id=<?= $row['id'] ?>">✏️ Edit</a> | 
                <a href="user_delete.php?id=<?= $row['id'] ?>" onclick="return confirm('Delete user?')">🗑 Delete</a>
            </td>
        </tr>
        <?php endwhile; ?>
    </table>
</body>
</html>
